﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ApplicationControl
{

    /// <summary>
    /// get operation related information
    /// </summary>
    public interface IAppOperations
    {
        /// <summary>
        /// get the compose operation
        /// </summary>
        /// <returns>compose operation</returns>
        string Compose();

        /// <summary>
        /// get the selected operation id
        /// </summary>
        /// <param name="SelectedOperation">selected operation name</param>
        /// <returns>selected operation id</returns>
        IEnumerable<string> GetMatchedApplicationIds(string SelectedOperation);

        /// <summary>
        /// send launch request
        /// </summary>
        /// <param name="SelectedOperation">selected operation</param>
        /// <param name="SelectedApp">selected operation app</param>
        void SendLaunchRequest(string SelectedOperation, string SelectedApp);

        /// <summary>
        /// get pick operation
        /// </summary>
        /// <returns>pick operation</returns>
        string Pick();

        /// <summary>
        /// get the view operation
        /// </summary>
        /// <returns>view operation</returns>
        string View();
    }
}
