﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System.Collections.Generic;
using ApplicationControl.Tizen;
using Tizen.Applications;

[assembly: Xamarin.Forms.Dependency(typeof(AppOperations))]
namespace ApplicationControl.Tizen
{
    /// <summary>
    /// get operation related information
    /// </summary>
    class AppOperations : IAppOperations
    {
        /// <summary>
        /// get the compose operation
        /// </summary>
        /// <returns>compose operation</returns>
        public string Compose()
        {
            return AppControlOperations.Compose;
        }

        /// <summary>
        /// get the selected operation id
        /// </summary>
        /// <param name="SelectedOperation">selected operation name</param>
        /// <returns>selected operation id</returns>
        public IEnumerable<string> GetMatchedApplicationIds(string SelectedOperation)
        {
            AppControl appControl = new AppControl
            {
                Operation = SelectedOperation,
                LaunchMode = AppControlLaunchMode.Group
            };
           return  AppControl.GetMatchedApplicationIds(appControl);
        }

        /// <summary>
        /// send launch request
        /// </summary>
        /// <param name="SelectedOperation">selected operation</param>
        /// <param name="SelectedApp">selected operation app</param>
        public void SendLaunchRequest(string SelectedOperation,string SelectedApp)
        {
            AppControl appControl = new AppControl
            {
                Operation = SelectedOperation,
                ApplicationId = SelectedApp
            };
            AppControl.SendLaunchRequest(appControl);
        }

        /// <summary>
        /// get pick operation
        /// </summary>
        /// <returns>pick operation</returns>
        public string Pick()
        {
            return AppControlOperations.Pick;
        }

        /// <summary>
        /// get the view operation
        /// </summary>
        /// <returns>view operation</returns>
        public string View()
        {
            return AppControlOperations.View;
        }
    }
}
