﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using ApplicationControl.Tizen;

[assembly: Xamarin.Forms.Dependency(typeof(ScreenSize))]
namespace ApplicationControl.Tizen
{
    /// <summary>
    /// get the screen size information
    /// </summary>
    class ScreenSize : ApplicationControl.IScreenSize
    {
        public static int ScreenWidth;
        public static int ScreenHeight;

        /// <summary>
        /// get the width of the screen
        /// </summary>
        /// <returns>the width of the screen</returns>
        public int GetWidth()
        {
            return ScreenWidth;
        }

        /// <summary>
        /// get the height of the screen
        /// </summary>
        /// <returns>the height of the screen</returns>
        public int GetHeight()
        {
            return ScreenHeight;
        }
    }
}
