/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Tizen.Applications;
using System.Globalization;
using Tizen.Xamarin.Forms.Extension.Renderer;
using System.Diagnostics;

namespace AppCommon.Tizen
{
    class Program : global::Xamarin.Forms.Platform.Tizen.FormsApplication
    {
        private App _app;

        protected override void OnCreate()
        {
            base.OnCreate();
            var width = MainWindow.ScreenSize.Width;
            var height = MainWindow.ScreenSize.Height;
            _app = new App(width, height);
            LoadApplication(_app);
            MainWindow.AvailableRotations = ElmSharp.DisplayRotation.Degree_0;
        }

        /// <summary>
        /// Handle LowBatter event
        /// </summary>
        /// <param name="e">An event data</param>
        protected override void OnLowBattery(LowBatteryEventArgs e)
        {
            base.OnLowBattery(e);
            var status = (LowBatteryStatus)e.LowBatteryStatus;
            _app.ApplicationInfomation.UpdateLowBatteryLEDColor(status);
        }

        /// <summary>
        /// Handle LowMemory event
        /// </summary>
        /// <param name="e">An event data</param>
        protected override void OnLowMemory(LowMemoryEventArgs e)
        {
            base.OnLowMemory(e);
            var status = (LowMemoryStatus)e.LowMemoryStatus;
            _app.ApplicationInfomation.UpdateLowMemoryLEDColor(status);
        }

        /// <summary>
        /// Handle LocaleChanged event
        /// </summary>
        /// <param name="e">An event data</param>
        protected override void OnLocaleChanged(LocaleChangedEventArgs e)
        {
            base.OnLocaleChanged(e);
            _app.ApplicationInfomation.Language = new CultureInfo(e.Locale).DisplayName;
        }

        /// <summary>
        /// Handle RegionFormatChanged event
        /// </summary>
        /// <param name="e">An event data</param>
        protected override void OnRegionFormatChanged(RegionFormatChangedEventArgs e)
        {
            base.OnRegionFormatChanged(e);
            _app.ApplicationInfomation.RegionFormat = new CultureInfo(e.Region).DisplayName;
        }

        /// <summary>
        /// Handle DeviceOrientation event
        /// </summary>
        /// <param name="e">An event data</param>
        protected override void OnDeviceOrientationChanged(DeviceOrientationEventArgs e)
        {
            base.OnDeviceOrientationChanged(e);
            var orientation = (DeviceOrientationStatus)e.DeviceOrientation;
            _app.ApplicationInfomation.UpdateDeviceOrientation(orientation);
        }

        static void Main(string[] args)
        {
            var app = new Program();
            TizenFormsExtension.Init();
            global::Xamarin.Forms.Platform.Tizen.Forms.Init(app);
            app.Run(args);
        }
    }
}