/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;
using Image = Xamarin.Forms.Image;
using Xamarin.Forms.PlatformConfiguration.TizenSpecific;
using Tizen.Xamarin.Forms.Extension;
using System;

namespace AppCommon.Extensions
{
    /// <summary>
    /// A class for an image enable to get click events.
    /// It can use as a button.
    /// </summary>
    public class ImageButton : Image, IButtonController
    {
        /// <summary>
        /// The constructor for an image button
        /// </summary>
        public ImageButton() : base()
        {
            var gestureRecognizer = new LongTapGestureRecognizer();
            gestureRecognizer.TapStarted += (s, e) =>
            {
                On<Xamarin.Forms.PlatformConfiguration.Tizen>().SetBlendColor(Color.FromRgb(213, 228, 240));
            };

            gestureRecognizer.TapCanceled += (s, e) =>
            {
                On<Xamarin.Forms.PlatformConfiguration.Tizen>().SetBlendColor(Color.Default);
            };

            gestureRecognizer.TapCompleted += (s, e) =>
            {
                On<Xamarin.Forms.PlatformConfiguration.Tizen>().SetBlendColor(Color.Default);
            };
            GestureRecognizers.Add(gestureRecognizer);
            Effects.Add(Effect.Resolve("AppCommon.ImageClickEffect"));
        }

        /// <summary>
        /// To broadcast a click event to subscribers
        /// </summary>
        public void SendClicked()
        {
            Clicked?.Invoke(this, EventArgs.Empty);
        }

        /// <summary>
        /// To bradcast a press event to subscribers
        /// </summary>
        public void SendPressed()
        {
            throw new NotImplementedException();
        }

        /// <summary>
        /// To bradcast a release event to subscribers
        /// </summary>
        public void SendReleased()
        {
            throw new NotImplementedException();
        }

        public event EventHandler Clicked;
    }
}