﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

namespace AppCommon
{
    public interface IAppInformation
    {
        /// <summary>
        /// get current applicationInfo's id
        /// </summary>
        /// <returns>Application Id</returns>
        string ApplicationId();

        /// <summary>
        /// get current directoryInfo's cache
        /// </summary>
        /// <returns>current cache directoryInfo</returns>
        string ApplicationCache();

        /// <summary>
        /// get current directoryInfo's external cache
        /// </summary>
        /// <returns>current external cache directoryInfo</returns>
        string ApplicationExternalCache();

        /// <summary>
        /// get current directoryInfo's external data
        /// </summary>
        /// <returns>current external data directoryInfo</returns>
        string ApplicationExternalData();

        /// <summary>
        /// get current directoryInfo's Shared Data
        /// </summary>
        /// <returns>current Shared Data directoryInfo</returns>
        string ApplicationExternalSharedData();

        /// <summary>
        /// get current application's name
        /// </summary>
        /// <returns>current application name</returns>
        string ApplicationName();

        /// <summary>
        /// get current directoryInfo's Resource
        /// </summary>
        /// <returns>current Resource directoryInfo</returns>
        string ApplicationResource();

        /// <summary>
        /// get current directoryInfo's Resource
        /// </summary>
        /// <returns>current Resource directoryInfo</returns>
        string ApplicationResources();

        /// <summary>
        /// get current directoryInfo's SharedDataPath
        /// </summary>
        /// <returns>current SharedDataPath directoryInfo</returns>
        string ApplicationSharedData();

        /// <summary>
        /// get current directoryInfo's SharedResourcePath
        /// </summary>
        /// <returns>current SharedResourcePath directoryInfo</returns>
        string ApplicationSharedResource();
        /// <summary>
        /// get current directoryInfo's SharedTrustedPath
        /// </summary>
        /// <returns>current SharedTrustedPath directoryInfo</returns>
        string ApplicationSharedTrusted();
    }
}
