﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using AppCommon.Tizen;
using System;
using System.Linq;
using Tizen.System;

[assembly: Xamarin.Forms.Dependency(typeof(StorageDetail))]

namespace AppCommon.Tizen
{
    /// <summary>
    /// The class for getting storage detail.
    /// </summary>
    public class StorageDetail : IStorage
    {
        /// <summary>
        /// Get storage status.
        /// </summary>
        public string LowMemoryStatus()
        {
            string status = "Normal";
            Storage internalStorage = StorageManager.Storages.Where(s => s.StorageType == StorageArea.Internal).FirstOrDefault();
            if (internalStorage.AvaliableSpace / 1024 / 1024 < 200)
            {
                status = "Low";
            }

            return status;
        }
    }
}
