﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace AppCommon
{
    /// <summary>
    /// display the application file paths
    /// </summary>
    public partial class Paths : ContentPage
    {
        // avoid initialize more than once.
        private bool _contentLoaded;
        IDirectory Directory;

        /// <summary>
        /// Initialize the tab page of path
        /// </summary>
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            Directory  = DependencyService.Get<IDirectory>();
            _contentLoaded = true;
            Title = "Paths";
            Padding = new Thickness(10, 10, 10, 10);

            ListView list = new ListView()
            {
                // set listview resource
                ItemsSource = _listItem,
                RowHeight = 120,
                // use template to construct the listview
                ItemTemplate = new DataTemplate(() =>
                {
                    Label titleLabel = new Label
                    {
                        VerticalTextAlignment = TextAlignment.Center,
                        FontSize = 15,
                        TextColor = Color.Black,
                    };
                    // set the bind between the listview and property of  ListData also the listview resource
                    titleLabel.SetBinding(Label.TextProperty, "Title");
                    Label pathLabel = new Label
                    {
                        VerticalTextAlignment = TextAlignment.Center,
                        FontSize = 13,
                        TextColor = Color.Gray,
                    };
                    // set the bind between the listview and property of  ListData also the listview resource
                    pathLabel.SetBinding(Label.TextProperty, "Path");

                    return new ViewCell
                    {
                        View = new StackLayout
                        {
                            Children =
                            {
                                titleLabel,
                                pathLabel
                            }
                        }
                    };
                })

            };

            Label path = new Label()
            {
                FontSize = 13,
                HorizontalTextAlignment = TextAlignment.Center
            };

            StackLayout filelayout = new StackLayout();

            ScrollView fileList = new ScrollView()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                HeightRequest = 300,
            };
            // find all file in current directory. show them
            StackLayout stack = new StackLayout()
            {
                Children =
                {
                    path,
                    new Label()
                    {
                        Text = "  Files list :",
                        TextColor = Color.Black,
                        FontSize = 13
                    },
                    fileList
                }
            };

            list.ItemTapped += async (s, e) =>
            {
                ListData data = (ListData)e.Item;
                path.Text = data.Path;
                if (Directory.Exists(data.Path))
                {
                    if (Directory.GetFiles(data.Path).Length == 0)
                    {
                        // set the content "No Files",when current directory is empty
                        fileList.Content = new StackLayout
                        {
                            Children =
                            {
                                new Label()
                                {
                                    HorizontalTextAlignment = TextAlignment.Start,
                                    Text = "   No Files"
                                }
                            }
                        };
                    }
                    else if (Directory.GetFiles(data.Path).Length > 0)
                    {
                        // clear previous loaded the content
                        filelayout.Children.Clear();
                        fileList.Content = filelayout;
                        // find all file in current directory. show them
                        foreach (string file in Directory.GetFiles(data.Path))
                        {
                            string value = file.Substring(data.Path.Length, file.Length - data.Path.Length);
                            filelayout.Children.Add(new Label()
                            {
                                HorizontalTextAlignment = TextAlignment.Start,
                                Text = "    " + value
                            });
                        }
                    }
                }
                else
                {
                    // set the content "No Files",if current directory no found
                    fileList.Content = new StackLayout
                    {
                        Children =
                        {
                            new Label()
                            {
                                HorizontalTextAlignment = TextAlignment.Start,
                                Text = "   No Files"
                            }
                        }
                    };
                }

                ContentPage NaviPage = new ContentPage()
                {
                    // create new pushmodalasync page
                    Content = stack,
                };
                await Navigation.PushModalAsync(NaviPage);
            };

            // set the content page as scroll view ,when the item is longer
            // enough ,you can scroll the content to see all the information
            Content = list;
        }
    }
}

