﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using AppCommon.Tizen;
using Tizen.System;

[assembly: Xamarin.Forms.Dependency(typeof(DeviceDetail))]

namespace AppCommon.Tizen
{
    /// <summary>
    /// The class for getting device detail.
    /// </summary>
    public class DeviceDetail : IDevice
    {
        /// <summary>
        /// Get battery status.
        /// </summary>
        public string BatteryStatus()
        {
            BatteryLevelStatus level = Battery.Level;
            Battery.LevelChanged += (s, e) =>
            {
                Events.SetBatteryStatus(GetBatteryStatus(Battery.Level));
            };
            return GetBatteryStatus(level);
        }

        /// <summary>
        /// Get battery string status by level.
        /// </summary>
        /// <param name="level">The battery level.</param>
        /// <returns>Return battery status.</returns>
        public string GetBatteryStatus(BatteryLevelStatus level)
        {
            string status = "Normal";
            switch (level)
            {
                case BatteryLevelStatus.Critical:
                    status = "Critical";
                    break;
                case BatteryLevelStatus.Empty:
                    status = "Empty";
                    break;
                case BatteryLevelStatus.Full:
                    status = "Full";
                    break;
                case BatteryLevelStatus.High:
                    status = "High";
                    break;
                case BatteryLevelStatus.Low:
                    status = "Low";
                    break;
                default:
                    status = "Normal";
                    break;
            }

            return status;
        }
    }
}
