﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace AppCommon
{
    /// <summary>
    /// display event information and monitor current app status
    /// </summary>
    public partial class Events : ContentPage
    {
        private bool _contentLoaded;
        private Label _value1;
        private Label _value2;
        private Label _value3;
        private Label _value4;

        /// <summary>
        /// Initialize the UI view of the tab page of event
        /// </summary>
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            _contentLoaded = true;

            Title = "Events";
            BackgroundColor = Color.Black;

            Label label1 = App.CreateLabel(20, TextAlignment.Start, Color.White);
            Label label2 = App.CreateLabel(20, TextAlignment.Start, Color.White);
            Label label3 = App.CreateLabel(20, TextAlignment.Start, Color.White);
            Label label4 = App.CreateLabel(20, TextAlignment.Start, Color.White);

            _value1 = App.CreateLabel(25, TextAlignment.Center, Color.White);
            _value2 = App.CreateLabel(25, TextAlignment.Center, Color.White);
            _value3 = App.CreateLabel(25, TextAlignment.Center, Color.White);
            _value4 = App.CreateLabel(25, TextAlignment.Center, Color.White);

            label1.Text = "   Low memory status:";
            label2.Text = "   Low battery status:";
            label3.Text = "   Language:";
            label4.Text = "   Region format:";

            _value1.Text = "--";
            _value2.Text = "--";
            _value3.Text = "--";
            _value4.Text = "--";


            StackLayout first = new StackLayout
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Gray,
                Children =
                {
                    label1, _value1
                }
            };

            StackLayout secnod = new StackLayout
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Gray,
                Children =
                {
                    label2, _value2
                }
            };

            StackLayout third = new StackLayout
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Gray,
                Children =
                {
                    label3, _value3
                }
            };

            StackLayout fourth = new StackLayout
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Gray,
                Children =
                {
                    label4, _value4
                }
            };

            StackLayout mainView = new StackLayout
            {
                Padding = 10,
                Margin = 10,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Black,
                Children =
                {
                    first,
                    secnod,
                    third,
                    fourth
                }
            };
            // the content of the event tab page
            Content = mainView;
        }
    }
}
