/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace AppCommon
{
    /// <summary>
    /// the main entry of the AppCommon
    /// </summary>
    public class App : Application
    {
        /// <summary>
        /// The class constructor.
        /// </summary>
        public App()
        {
            AppInfo = DependencyService.Get<IAppInformation>();
            Page Appliction = new ApplicationInformation(AppInfo.ApplicationId(), AppInfo.ApplicationName());
            Page Events = new Events();
            Page Paths = new Paths();
            // The root page of your application
            MainPage = new TabbedPage
            {
                Children =
                {
                    Appliction,
                    Events,
                    Paths,
                }
            };
        }

        /// <summary>
        /// create a label with given size ,text alignment and text color
        /// </summary>
        /// <param name="size">the size of the label</param>
        /// <param name="alignment">the text align of the label</param>
        /// <param name="color">the text color of the label</param>
        /// <returns>return the created label</returns>
        internal static Label CreateLabel(int size, TextAlignment alignment, Color color)
        {
            Label label = new Label
            {
                FontSize = size,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                HorizontalTextAlignment = alignment,
                TextColor = color,
            };
            return label;
        }

        /// <summary>
        /// the application information ,initialized in the constructor
        /// </summary>
        public IAppInformation AppInfo;
        protected override void OnStart()
        {
            // Handle when your app starts
        }

        protected override void OnSleep()
        {
            // Handle when your app sleeps
        }

        protected override void OnResume()
        {
            // Handle when your app resumes
        }
    }
}
