﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using AppCommon.Tizen;

[assembly: Xamarin.Forms.Dependency(typeof(AppInformation))]

namespace AppCommon.Tizen
{
    class AppInformation : Xamarin.Forms.Platform.Tizen.FormsApplication, IAppInformation
    {
        /// <summary>
        /// get current applicationInfo's id
        /// </summary>
        /// <returns>Application Id</returns>
        public string ApplicationId()
        {
            return Current.ApplicationInfo.ApplicationId;
        }

        /// <summary>
        /// get current directoryInfo's cache
        /// </summary>
        /// <returns>current cache directoryInfo</returns>
        public string ApplicationCache()
        {
            return Current.DirectoryInfo.Cache;
        }

        /// <summary>
        /// get current directoryInfo's external cache
        /// </summary>
        /// <returns>current external cache directoryInfo</returns>
        public string ApplicationExternalCache()
        {
            return Current.DirectoryInfo.ExternalCache;
        }

        /// <summary>
        /// get current directoryInfo's external data
        /// </summary>
        /// <returns>current external data directoryInfo</returns>
        public string ApplicationExternalData()
        {
            return Current.DirectoryInfo.ExternalData;
        }

        /// <summary>
        /// get current directoryInfo's Shared Data
        /// </summary>
        /// <returns>current Shared Data directoryInfo</returns>
        public string ApplicationExternalSharedData()
        {
            return Current.DirectoryInfo.ExternalSharedData;
        }

        /// <summary>
        /// get current application's name
        /// </summary>
        /// <returns>current application name</returns>
        public string ApplicationName()
        {
            return Current.ApplicationInfo.Label;
        }

        /// <summary>
        /// get current directoryInfo's Resource
        /// </summary>
        /// <returns>current Resource directoryInfo</returns>
        public string ApplicationResource()
        {
            return Current.DirectoryInfo.Resource;
        }

        /// <summary>
        /// get current directoryInfo's Resource
        /// </summary>
        /// <returns>current Resource directoryInfo</returns>
        public string ApplicationResources()
        {
            return Current.DirectoryInfo.Resource;
        }

        /// <summary>
        /// get current directoryInfo's SharedDataPath
        /// </summary>
        /// <returns>current SharedDataPath directoryInfo</returns>
        public string ApplicationSharedData()
        {
            return Current.ApplicationInfo.SharedDataPath;
        }

        /// <summary>
        /// get current directoryInfo's SharedResourcePath
        /// </summary>
        /// <returns>current SharedResourcePath directoryInfo</returns>
        public string ApplicationSharedResource()
        {
            return Current.ApplicationInfo.SharedResourcePath;
        }

        /// <summary>
        /// get current directoryInfo's SharedTrustedPath
        /// </summary>
        /// <returns>current SharedTrustedPath directoryInfo</returns>
        public string ApplicationSharedTrusted()
        {
            return Current.ApplicationInfo.SharedTrustedPath;
        }
    }
}
