﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;
using System.IO;

namespace AppCommon
{
    /// <summary>
    /// display the application file paths
    /// </summary>
    public partial class Paths : ContentPage
    {
        /// avoid initialize more than once.
        private bool _contentLoaded;

        /// <summary>
        /// Initialize the tab page of path
        /// </summary>
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            _contentLoaded = true;
            Title = "Paths";
            Padding = new Thickness(10, 10, 10, 10);

            ListView list = new ListView()
            {
                //set listview resource
                ItemsSource = _listItem,
                RowHeight = 120,
                //use template to construct the listview
                ItemTemplate = new DataTemplate(() =>
                {
                    Label titleLabel = new Label
                    {
                        VerticalTextAlignment = TextAlignment.Center,
                        FontSize = 30,
                        TextColor = Color.Black,
                    };
                    //set the bind between the listview and property of  ListData also the listview resource
                    titleLabel.SetBinding(Label.TextProperty, "Title");
                    Label pathLabel = new Label
                    {
                        VerticalTextAlignment = TextAlignment.Center,
                        FontSize = 25,
                        TextColor = Color.Gray,
                    };
                    //set the bind between the listview and property of  ListData also the listview resource
                    pathLabel.SetBinding(Label.TextProperty, "Path");

                    return new ViewCell
                    {
                        View = new StackLayout
                        {
                            Children =
                            {
                                titleLabel,
                                pathLabel
                            }
                        }
                    };
                })

            };

            Label path = new Label()
            {
                FontSize = 25,
                HorizontalTextAlignment = TextAlignment.Center
            };
            Label nofile = new Label()
            {
                HorizontalTextAlignment = TextAlignment.Center,
                Text = "No Files"
            };
            StackLayout filelayout = new StackLayout();

            ScrollView fileList = new ScrollView()
            {
                HeightRequest = 200
            };
            StackLayout stack = new StackLayout()
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                Children =
                {
                    path,
                    new Label()
                    {
                        Text = "  Files list :",
                        TextColor = Color.Black,
                        FontSize = 25
                    },
                    fileList
                }
            };

            Button button = new Button()
            {
                Text = "Close"
            };

            button.Clicked += (s, e) =>
            {
                filelayout.Children.Clear();
            };

            list.ItemSelected += (s, e) =>
            {
                ListData data = (ListData)e.SelectedItem;
                path.Text = data.Path;
            };

            ScrollView scroll = new ScrollView()
            {
                Content = list
            };

            //set the content page as scroll view ,when the item is longer
            //enough ,you can scroll the content to see all the information
            Content = scroll;
        }
    }
}

