﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using System.Collections.Generic;
using Xamarin.Forms; // we added this namespace as a reference

namespace AppCommon
{
    /// <summary>
    /// display the application file paths information
    /// </summary>
    public partial class Paths : ContentPage
    {
        private AppInformation _appinfo;
        private IList<ListData> _listItem = new List<ListData>();
        public Paths(AppInformation AppInfo)
        {
            _appinfo = AppInfo;
            SetlistItem();
            InitializeComponent();
            // created Initialization and user logic
        }

        /// <summary>
        /// the listview resource struct
        /// </summary>
        void SetlistItem()
        {
            _listItem.Add(new ListData
            {
                Title = "Data",
                Path = _appinfo.ApplicationResources
            });
            _listItem.Add(new ListData
            {
                Title = "Cache",
                Path = _appinfo.ApplicationCache
            });
            _listItem.Add(new ListData
            {
                Title = "Resource",
                Path = _appinfo.ApplicationResource
            });
            _listItem.Add(new ListData
            {
                Title = "SharedData",
                Path = _appinfo.ApplicationSharedData
            });
            _listItem.Add(new ListData
            {
                Title = "SharedResource",
                Path = _appinfo.ApplicationSharedResource
            });
            _listItem.Add(new ListData
            {
                Title = "SharedTrusted",
                Path = _appinfo.ApplicationSharedTrusted
            });
            _listItem.Add(new ListData
            {
                Title = "ExternalData",
                Path = _appinfo.ApplicationExternalData
            });
            _listItem.Add(new ListData
            {
                Title = "ExternalCache",
                Path = _appinfo.ApplicationExternalCache
            });
            _listItem.Add(new ListData
            {
                Title = "ExternalSharedData",
                Path = _appinfo.ApplicationExternalSharedData
            });
        }

    }

    /// <summary>
    /// the listview item data struct
    /// </summary>
    public struct ListData
    {
        private string title;
        private string path;

        /// <summary>
        ///  Title property</summary>
        ///  <value>
        /// A value tag is used to describe the property value.</value>
        public string Title
        {
            get
            {
                return title;
            }

            set
            {
                title = value;
            }
        }

        /// <summary>
        ///  Path property</summary>
        ///  <value>
        /// A value tag is used to describe the property value.</value>
        public string Path
        {
            get
            {
                return path;
            }

            set
            {
                path = value;
            }
        }
    }
}
