/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;

namespace AppCommon
{
    /// <summary>
    /// the main entry of the AppCommon
    /// </summary>
    public class App : Application
    {
        /// <summary>
        /// The class constructor.
        /// </summary>
        /// <param name="appInfo">the application information  contain the ApplicationId,
        /// ApplicationName,Applicationresource and so on</param>
        /// <seealso cref="AppInformation">there are contain all the information this app need</seealso>
        public App(AppInformation appInfo)
        {
            AppInfo = appInfo;
            Page Appliction = new ApplicationInformation(AppInfo.ApplicationId, AppInfo.ApplicationName);
            Page Events = new Events();
            Page Paths = new Paths(AppInfo);
            // The root page of your application
            MainPage = new TabbedPage
            {
                Children =
                {
                    Appliction,
                    Events,
                    Paths,
                }
            };
        }

        /// <summary>
        /// create a label with given size ,textalign and textcolor
        /// </summary>
        /// <param name="size">the size of the lable</param>
        /// <param name="alignment">the textalign of the lable</param>
        /// <param name="color">the textcolor of the lable</param>
        /// <returns>return the created label</returns>
        internal static Label CreateLabel(int size, TextAlignment alignment, Color color)
        {
            Label label = new Label
            {
                FontSize = size,
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                HorizontalTextAlignment = alignment,
                TextColor = color,
            };
            return label;
        }

        /// <summary>
        /// the application information ,initialized in the constructor
        /// </summary>
        public AppInformation AppInfo;
        protected override void OnStart()
        {
            // Handle when your app starts
        }

        protected override void OnSleep()
        {
            // Handle when your app sleeps
        }

        protected override void OnResume()
        {
            // Handle when your app resumes
        }
    }
}
