/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using AppCommon;

namespace Tizen
{
    class Program : global::Xamarin.Forms.Platform.Tizen.FormsApplication
    {
        protected override void OnCreate()
        {
            var AppInfo = new AppInformation();
            AppInfo.ApplicationId = Tizen.Program.Current.ApplicationInfo.ApplicationId;
            AppInfo.ApplicationName = Tizen.Program.Current.ApplicationInfo.Label;
            AppInfo.ApplicationResources = Tizen.Program.Current.DirectoryInfo.Resource;
            AppInfo.ApplicationCache = Tizen.Program.Current.DirectoryInfo.Cache;
            AppInfo.ApplicationResource = Tizen.Program.Current.DirectoryInfo.Resource;
            AppInfo.ApplicationSharedData = Tizen.Program.Current.ApplicationInfo.SharedDataPath;
            AppInfo.ApplicationSharedResource = Tizen.Program.Current.ApplicationInfo.SharedResourcePath;
            AppInfo.ApplicationSharedTrusted = Tizen.Program.Current.ApplicationInfo.SharedTrustedPath;
            AppInfo.ApplicationExternalCache = Tizen.Program.Current.DirectoryInfo.ExternalCache;
            AppInfo.ApplicationExternalData = Tizen.Program.Current.DirectoryInfo.ExternalData;
            AppInfo.ApplicationExternalSharedData = Tizen.Program.Current.DirectoryInfo.ExternalSharedData;
            var appcommon = new App(AppInfo);

            base.OnCreate();
            LoadApplication(appcommon);
        }

        static void Main(string[] args)
        {
            var app = new Program();
            Xamarin.Forms.Platform.Tizen.Forms.Init(app);
            app.Run(args);
        }
    }
}
