﻿/*
 * Copyright (c) 2016 Samsung Electronics Co., Ltd
 *
 * Licensed under the Flora License, Version 1.1 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://floralicense.org/license/
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

using Xamarin.Forms;


namespace AppCommon
{
    /// <summary>
    /// display application information:id,name ,version
    /// </summary>
    public partial class ApplicationInformation : ContentPage
    {
        private bool _contentLoaded;
        void InitializeComponent()
        {
            if (_contentLoaded)
            {
                return;
            }

            _contentLoaded = true;


            Title = "Application";
            IsVisible = true;

            BackgroundColor = Color.Black;

            Label label1 = App.CreateLabel(45, TextAlignment.Start, Color.White);
            Label label2 = App.CreateLabel(45, TextAlignment.Start, Color.White);
            Label label3 = App.CreateLabel(45, TextAlignment.Start, Color.White);
            Label value1 = App.CreateLabel(40, TextAlignment.Center, Color.White);
            Label value2 = App.CreateLabel(40, TextAlignment.Center, Color.White);
            Label value3 = App.CreateLabel(40, TextAlignment.Center, Color.White);

            label1.Text = "   Application name:";
            label2.Text = "   Application id:";
            label3.Text = "   Application version:";
            //the id of application
            value1.Text = _applicationId;
            //the name of application
            value2.Text = _applicationName;
            //the version of application
            value3.Text = "1.0.0.0";

            StackLayout first = new StackLayout
            {
                Padding = new Thickness(0, 30, 0, 0),
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Gray,
                Children =
                {
                    label1,
                    value1
                }
            };

            StackLayout second = new StackLayout
            {
                Padding = new Thickness(0, 30, 0, 0),
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Gray,
                Children =
                {
                    label2,
                    value2
                }
            };

            StackLayout third = new StackLayout
            {
                Padding = new Thickness(0, 30, 0, 0),
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Gray,
                Children =
                {
                    label3,
                    value3
                }
            };

            //blank stacklayout for beautiful display
            StackLayout blank = new StackLayout
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                HeightRequest = 10,
                BackgroundColor = Color.Black,
            };

            //blank stacklayout for beautiful display
            StackLayout blank1 = new StackLayout
            {
                HorizontalOptions = LayoutOptions.FillAndExpand,
                HeightRequest = 10,
                BackgroundColor = Color.Black,
            };

            StackLayout mainView = new StackLayout
            {
                Padding = new Thickness(10),
                HorizontalOptions = LayoutOptions.FillAndExpand,
                VerticalOptions = LayoutOptions.FillAndExpand,
                BackgroundColor = Color.Black,
                Children =
                {
                    first,
                    blank,
                    second,
                    blank1,
                    third,
                }
            };

            Content = mainView;
        }
    }
}
