window.onload = function() {

    var ballRedUp = anime({

        targets: "#ballRed",
        translateY: [0, -100],
        duration: 1000,
        complete: function() {
            ballRedDown.restart();
        }

    });

    var ballRedDown = anime({

        targets: "#ballRed",
        translateY: [-100, 0],
        duration: 1000,
        easing: "easeOutBounce",
        autoplay: false,
        complete: function() {
            ballRedUp.restart();
        }

    });

    var eyeBallsUp = anime({

        targets: ["#leftEyeBall", "#rightEyeBall", "#mouth"],
        translateY: [0, -10],
        scale: 1.05,
        fill: "#FF0000",
        duration: 1000,
        complete: function() {
            eyeBallsDown.restart();
        }

    });

    var eyeBallsDown = anime({

        targets: ["#leftEyeBall", "#rightEyeBall", "#mouth"],
        translateY: [-10, 0],
        scale: 1,
        fill: "#000000",
        duration: 1000,
        easing: "easeOutBounce",
        autoplay: false,
        complete: function() {
            eyeBallsUp.restart();
        }

    });

    var leftHandRotate = anime({

        targets: "#leftHand",
        rotate: [-2, 1],
        duration: 1000,
        loop: true,
        direction: "alternate"

    });

    // add eventListener for tizenhwkey
    document.addEventListener("tizenhwkey", function(e) {
        if (e.keyName === "back") {
            try {
                tizen.application.getCurrentApplication().exit();
            } catch (ignore) {}
        }
    });

};