/*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
 * 
 * 
 * @author Tomasz Scislo <<ahref='mailto:t.scislo@samsung.com'>t.scislo@samsung.com</a>>
 * 
 * 
 * **************************************************************************************
 * 
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 * 
 ******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/

package com.samsung.srpol.androidearthguard;

import android.webkit.JavascriptInterface;

public class WebAppInterface {
	MainActivity mActivity;

	// PowerManager.WakeLock mWakeLock;

	/** Instantiate the interface and set the context */
	WebAppInterface(MainActivity a) {
		mActivity = a;
		// mWakeLock = wakeLock;
	}

	/**
	 * Method available in JS application
	 */
	@JavascriptInterface
	public void exitApplication() {
		mActivity.finish();
	}

	/**
	 * Method available in JS application. Switch on/off preventing the screen from dimming
	 * 
	 * @param screenOn
	 *            true if we want to prevent the screen from dimming, false if we want to release it
	 */
	@JavascriptInterface
	public void setScreenOn(boolean screenOn) {
		mActivity.setScreenOn(screenOn);
	}

}
