/*******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************
 * 
 * 
 * @author Tomasz Scislo <<ahref='mailto:t.scislo@samsung.com'>t.scislo@samsung.com</a>>
 * 
 * 
 * **************************************************************************************
 * 
 * Copyright (c) 2012 Samsung Electronics All Rights Reserved.
 * 
 ******************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/

package com.samsung.srpol.androidearthguard;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.PowerManager;
import android.util.Log;
import android.view.KeyEvent;
import android.webkit.ConsoleMessage;
import android.webkit.WebChromeClient;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;

public class MainActivity extends Activity {
	private WebView mWebView;
	private WebAppInterface mWebAppInterface;
	private PowerManager.WakeLock mWakeLock;
	private boolean mScreenOn = false;

	@SuppressLint("SetJavaScriptEnabled")
	private void initWebView() {
		WebSettings webSettings = mWebView.getSettings();
		// Enables JS support for WebView
		webSettings.setJavaScriptEnabled(true);
		// Persistent localStorage in JS
		webSettings.setDomStorageEnabled(true);
		mWebView.getSettings().setDatabasePath("/data/data/" + mWebView.getContext().getPackageName() + "/databases/");
		// Provides Android namespace in JS application
		mWebView.addJavascriptInterface(mWebAppInterface, "Android");
		mWebView.setWebViewClient(new WebViewClient());
		// console.log messages visible on LogCat
		mWebView.setWebChromeClient(new WebChromeClient() {
			public boolean onConsoleMessage(ConsoleMessage cm) {
				Log.d(getString(R.string.js_console_tag),
						"[EarthGuard]: " + cm.message() + " -> line(" + cm.lineNumber() + ") of " + cm.sourceId());
				return true;
			}
		});

		// Additional string suffix to user agent visible in JS application
		webSettings.setUserAgentString(webSettings.getUserAgentString() + " " + getString(R.string.user_agent_suffix));

		// Loads application main page in WebView
		mWebView.loadUrl(getString(R.string.web_application_url));
	}

	@SuppressWarnings("deprecation")
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.activity_main);
		PowerManager pm = (PowerManager) getSystemService(Context.POWER_SERVICE);
		mWakeLock = pm.newWakeLock(PowerManager.SCREEN_BRIGHT_WAKE_LOCK, "MainActivity");
		mWebView = (WebView) findViewById(R.id.webview);
		mWebAppInterface = new WebAppInterface(this);
		initWebView();
	}

	/**
	 * Triggers game.onVisible() method in JS application
	 * 
	 */
	@Override
	protected void onResume() {
		super.onResume();
		Log.d(this.getClass().getName(), "Main activity onResume()");
		mWebView.loadUrl("javascript:game.onVisible()");
		if (mScreenOn) {
			mWakeLock.acquire();
		}
	}

	/**
	 * Triggers game.onHidden() method in JS application
	 * 
	 */
	@Override
	protected void onPause() {
		super.onPause();
		Log.d(this.getClass().getName(), "Main activity onPause()");
		mWebView.loadUrl("javascript:game.onHidden()");
		if (mWakeLock.isHeld()) {
			mWakeLock.release();
		}
	}

	@Override
	public boolean onKeyDown(int keyCode, KeyEvent event) {
		// Back button handler
		if ((keyCode == KeyEvent.KEYCODE_BACK)) {
			Log.d(this.getClass().getName(), "back button pressed");
			mWebView.loadUrl("javascript:menu.toggle()");
			return false;
		}
		return super.onKeyDown(keyCode, event);
	}

	/**
	 * Method handles power management
	 * 
	 * @param screenOn
	 *            true if we want to prevent the screen from dimming, false if we want to release it
	 */
	public void setScreenOn(boolean screenOn) {
		mScreenOn = screenOn;
		if (screenOn && !mWakeLock.isHeld()) {
			mWakeLock.acquire();
		} else if (!screenOn && mWakeLock.isHeld()) {
			mWakeLock.release();
		}
	}
}
