"use strict";
var PlayerMissile = function(x, y) {
	this.type = game.getObjectTypes().PLAYER_MISSILE;
	this.setup('missile', {
		damage : 10
	});
	this.x = x - this.w / 2;
	// Use the passed in y as the bottom of the missile
	this.y = y - this.h;
	// y velocity of Player Missile
	this.vy = -700;

	/**
	 * Function: - change the y position of the missile, - checks if the PlayerMissile isn't outside the board (if yes - removes the missile), - checks if the PlayerMissile collides with Enemy,
	 * 
	 * @param dt
	 */
	this.step = function(dt) {
		this.y += this.vy * dt;

		if (this.y < config.player.topOffset) {
			this.board.remove(this);
		}

		var collision = this.board.collide(this, game.getObjectTypes().ENEMY);
		if (collision) {
			collision.hit(this.damage);
			this.hit();
		}
	};

	/**
	 * Function defines how collision with other object affects the PlayerMissile (it destroys the missile and removes it from board)
	 */
	this.hit = function() {
		this.board.add(new Explosion(this.x + this.w / 2, this.y + this.h, "explosion_yellow_small"), 100);
		this.board.remove(this);
	}
};

game.inherit(PlayerMissile, Sprite);