"use strict";
var Earth = function(hud) {
	this.type = game.getObjectTypes().EARTH;
	this.setup('earth');
	// Position of Earth
	this.x = 0;
	this.y = view.getHeight() - this.h;
	// Health of Earth
	this.maxHealth = this.health = 2500;
	this.hud = hud;
	this.hud.setEarthLife(this.health / this.maxHealth * 100);
	this.percentValue;
	/**
	 * Function (in every step) checks if the Earth collides with Enemy
	 * 
	 * @param dt
	 */
	this.step = function(dt) {
		var collision = this.board.collide(this, game.getObjectTypes().ENEMY);
		if (collision) {
			this.hit(collision.damage);
			// Collision with Earth destroys the enemy
			collision.hit(collision.health, "explosion_green");
		}
	};

	/**
	 * Function defines how collision with other object affects the Earth, changes sprite of Earth
	 * 
	 * @param damage {Number} defines stage of destruction
	 */
	this.hit = function(damage) {
		this.health -= damage;

		if (this.health <= 0)
			this.board.remove(this);
		else {
			this.percentValue = this.health/this.maxHealth * 100;
			// Changes of Earth image (4 stages of destruction)
			if (this.percentValue <= 75)
				if (this.percentValue <= 50) {
					if (this.percentValue <= 25)
						this.setup('earth_4');
					else
						this.setup('earth_3');
				} else
					this.setup('earth_2');
		}
		this.hud.setEarthLife(this.health / this.maxHealth * 100);
	};

	this.heal = function() {
		var repair = this.maxHealth * config.powerUps.healPercantage/100;
		var updatedHealth = this.health + repair;
		
		if (updatedHealth > this.maxHealth) {
			this.health = this.maxHealth;
		} else {
			this.health = updatedHealth;
		}
		
		this.hud.setEarthLife(this.health / this.maxHealth * 100);
	}
};

game.inherit(Earth, Sprite);