"use strict";
var Star = function(x, y, period, size) {
	this.type = game.getObjectTypes().STAR;
	this.setup('star', {
		frame : 0
	});
	this.x = x;
	this.y = y;
	this.subFrame = 0;
	this.period = period;
	this.size = size;
	this.step = function(dt) {
		this.frame = Math.floor(this.subFrame++ / this.period);
		this.frame %= 10;
	};

	this.draw = function(ctx) {
		if (this.period !== 0)
			spriteSheet.draw(ctx, this.sprite, this.x, this.y, this.frame);
		else {
			ctx.fillStyle = "#FFFFFF";
			ctx.fillRect(this.x, this.y, this.size, this.size);
		}
	};
};

game.inherit(Star, Sprite);
