"use strict";
var Overheat = function() {
	this.type = game.getObjectTypes().OVERHEAT;
	this.setup('overheat');
	this.h = 397; // resets the height of sprite
	this.x = view.getWidth() - this.w - 5;
	this.y = view.getHeight() - this.h - 166;
	this.overheatStage = 0; // 0 (min) .. 40 (max)  stage of overheating 
	this.fireTime = 0; 
	this.overheatLength = 40; // number of overheat's marks
	this.blockFire = false; // block the 'fire' key
	
	/**
	 * Function (in every step) checks if 'fire' key is pressed, blocks key if necessary and sets proper stage of overheating
	 * @param dt  
	 */
	this.step = function(dt) {
		var a = config.overheating.timeToOverheat/config.overheating.timeToRecovery;
		
		if (!this.blockFire) {
			// if shooting isn't blocked 
			if (game.keys['fire']) {
				if (this.fireTime < config.overheating.timeToOverheat)
					this.fireTime += dt; 
				else {
					// overheat => block fire
					this.blockFire = true;
				}
			} else {
				if (this.fireTime > 0)
					this.fireTime -= a * dt;
			}
		} else {
			// if shooting is blocked
			if (this.fireTime > 0)
				this.fireTime -= a * dt;
			else 
				this.blockFire = false;
		}
		
		if (this.fireTime < 0)
			this.fireTime = 0;
		
		this.overheatStage = Math.floor((this.overheatLength/config.overheating.timeToOverheat) * this.fireTime);
	};
	
	/**
	 * Function draws the overheat sprite
	 * @param ctx {2DContext} Canvas 2D Context to draw on
	 */
	this.draw = function(ctx) {
		if (this.overheatStage > 0) {
			spriteSheet.getSprites()[this.sprite].h = this.overheatStage * 10 - 3;
			spriteSheet.getSprites()[this.sprite].sy = 2566 - this.overheatStage * 10;
			spriteSheet.draw(ctx, this.sprite, this.x, this.y + ((40 - this.overheatStage) * 10), this.frame);
		}
	};
};

game.inherit(Overheat, Sprite);