/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

#include "main.h"

int is_ready = 0;
Evas_Object *label;

void
request_success_interstitial( void *user_data)
{
	is_ready = 1;
	dlog_print(DLOG_DEBUG, LOG_TAG, "REQUEST SUCCESS CALLBACK");
}

void
request_failed_interstitial(adlib_err err,  void *user_data)
{
	dlog_print(DLOG_DEBUG, LOG_TAG, "REQUEST FAILED CALLBACK");
}

void
ad_opened_interstitial( void *user_data)
{
	dlog_print(DLOG_DEBUG, LOG_TAG, "AD OPENED CALLBACK");
}

void
ad_closed_interstitial( void *user_data)
{
	dlog_print(DLOG_DEBUG, LOG_TAG, "AD CLOSED CALLBACK");
}


static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	dlog_print(DLOG_DEBUG, LOG_TAG, "naviframe_pop_cb");
	adview_interstitial_load();
	return EINA_TRUE;
}



void
interstitial_ad_page_cb(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *nf = data;
	Elm_Object_Item *nf_it;

	Evas_Object *ad_layout = elm_layout_add(nf);
	elm_layout_theme_set(ad_layout, "layout", "application", "default");

	label = elm_label_add(ad_layout);
	elm_object_part_content_set(ad_layout,"elm.swallow.content", label);


	if (is_ready) {
		char text[128] = {0, };

		if (adview_interstitial_show())
			snprintf(text, 127, "<align=center><font_size=32>Interstitial ad SHOWN</font_size></align>");
		else
			snprintf(text, 127, "<align=center><font_size=32>Interstitial ad NOT YET FETCHED</font_size></align>");

		elm_object_text_set(label, text);
		is_ready = 0;
	} else {
		char text[128] = {0, };
		snprintf(text, 127, "<align=center><font_size=32>Interstitial ad NOT YET FETCHED</font_size></align>");
		elm_object_text_set(label, text);
	}
	adview_interstitial_show();
	evas_object_show(label);

	nf_it = elm_naviframe_item_push(nf, "Interstitial Ad", NULL, NULL, ad_layout, NULL);
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, NULL);
}
