/*
 * banner_ad_view_swallow.c
 *
 *  Created on: Jan 4, 2016
 *      Author: anand.r
 */

#include "main.h"
#include <wifi.h>
#include <adlib.h>
//#define ELM_DEMO_EDJ "/opt/usr/apps/org.tizen.adlibviewexample/res/adlibviewexample.edj"

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	dlog_print(DLOG_DEBUG, LOG_TAG, "naviframe_pop_cb");
	appdata_s *ad = (appdata_s *)data;

	evas_object_del(ad->banner_handle_1);//No need to delete banner_handle_2 since it is swallowed in to layout

	return EINA_TRUE;//Return true so that framework will delete the layout if return false, app need to take care of deleting adview
}

static void
request_failed_banner(Evas_Object *banner_handle, adlib_err err,void *user_data)
{
		dlog_print(DLOG_DEBUG, LOG_TAG, "ANAND REQUEST FAILED");
}

static void
request_success_banner(Evas_Object *banner_handle, void *user_data)
{
	dlog_print(DLOG_DEBUG, LOG_TAG, "REQUEST SUCCESS CALLBACK");
	appdata_s *ad = (appdata_s *)user_data;
	if(banner_handle == ad->banner_handle_1)//Only Showing overlay ad...other ad swallowed in to layout will be shown by default by efl
		evas_object_show(banner_handle);
}

void
banner_ad_page_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = (appdata_s *)data;
	Elm_Object_Item *nf_it;

	Evas_Object *ad_layout = elm_layout_add(ad->nf);
	elm_layout_file_set(ad_layout, ELM_DEMO_EDJ, "main");

	/*#ADLIB_CODE Adding banner ad to same layout and swallowing it. START*/
	adview_add_banner_ad(&ad->banner_handle_2, ad_layout, BANNER_AD_SIZE_SMALL);
	elm_object_part_content_set(ad_layout, "adswallow", ad->banner_handle_2);
	evas_object_size_hint_align_set(ad->banner_handle_2, 0.5, 0.5);

	//evas_object_show(ad->banner_handle_2);//No Need to show since it is swallowed in to layout
	adview_banner_load(ad->banner_handle_2);

	banner_ad_event_callback_s callback = {0,};
	callback.banner_ad_load_request_failed = request_failed_banner;
	callback.banner_ad_load_request_succeeded = request_success_banner;



	adview_add_banner_ad(&ad->banner_handle_1, ad->win, BANNER_AD_SIZE_BIG);
	/*#ADLIB_CODE Adding banner ad to same layout and swallowing it. END*/

	/*#ADLIB_CODE Showing banner ad created on main win and setting the position. START*/
	adview_banner_load(ad->banner_handle_1);
	adview_banner_ad_register_callbacks(ad->banner_handle_1, &callback, ad);
	adview_banner_ad_register_callbacks(ad->banner_handle_2, &callback, ad);
	adview_banner_ad_set_position(ad->banner_handle_1, BANNER_AD_POSITION_CENTER);
	/*#ADLIB_CODE Showing banner ad created on main win and setting the position. END*/

	nf_it = elm_naviframe_item_push(ad->nf, "Banner Ads", NULL, NULL, ad_layout, NULL);
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
