/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

/*
 * banner_ad_advanced.c
 *
 *  Created on: Jan 18, 2016
 *      Author: anand.r
 */

#include "main.h"

static Eina_Bool
naviframe_pop_cb(void *data, Elm_Object_Item *it)
{
	dlog_print(DLOG_DEBUG, LOG_TAG, "naviframe_pop_cb");
	appdata_s *ad = (appdata_s *)data;
	evas_object_hide(ad->banner_handle_3);
	return EINA_TRUE;
}

static void
hoversel_selected_cb(void *data, Evas_Object *obj, void *event_info)
{
	const char *txt = elm_object_item_text_get((Elm_Object_Item *) event_info);
	appdata_s *ad = (appdata_s *)data;
	int i = (int) evas_object_data_get(obj, "index");
	dlog_print(DLOG_DEBUG, LOG_TAG, "index %d", i);
	evas_object_hide(ad->banner_handle_3);
	switch(i){
	case 1:
		if(!strcmp(txt,"Auto Refresh: 30 sec"))
		{
			adview_banner_set_enable_auto_refresh(ad->banner_handle_3, EINA_TRUE);
			adview_banner_set_refresh_interval(ad->banner_handle_3, 30);
		}
		else if(!strcmp(txt,"Auto Refresh: 60 sec"))
		{
			adview_banner_set_enable_auto_refresh(ad->banner_handle_3, EINA_TRUE);
			adview_banner_set_refresh_interval(ad->banner_handle_3, 60);
		}else
			adview_banner_set_enable_auto_refresh(ad->banner_handle_3, EINA_FALSE);

		break;
	case 2:
		if(!strcmp(txt,"Male"))
			adlib_set_gender(ADLIB_AD_GENDER_MALE);
		else
			adlib_set_gender(ADLIB_AD_GENDER_FEMALE);
		break;
	case 3:
		if(!strcmp(txt,"18"))
		adlib_set_age(18);
		else if(!strcmp(txt,"24"))
			adlib_set_age(24);
		else if(!strcmp(txt, "34"))
			adlib_set_age(34);
		else if(!strcmp(txt,"44"))
			adlib_set_age(44);
		break;


	default:
		break;
	}

	adview_banner_load(ad->banner_handle_3);
	elm_object_text_set(obj, txt);
}


static void
request_failed_banner(Evas_Object *banner_handle, adlib_err err,void *user_data)
{
		dlog_print(DLOG_DEBUG, LOG_TAG, "REQUEST FAILED");
}

static void
request_success_banner(Evas_Object *banner_handle, void *user_data)
{
	dlog_print(DLOG_DEBUG, LOG_TAG, "REQUEST SUCCESS CALLBACK");
	appdata_s *ad = (appdata_s *)user_data;
	if(banner_handle == ad->banner_handle_3)//Only Showing overlay ad...other ad swallowed in to layout will be shown by default by efl
		evas_object_show(banner_handle);
}

void
banner_ad_advanced_cb(void *data, Evas_Object *obj, void *event_info)
{
	appdata_s *ad = (appdata_s *)data;
	Elm_Object_Item *nf_it;
	Evas_Object *box, *hoversel;

	Evas_Object *ad_layout = elm_layout_add(ad->nf);
	evas_object_size_hint_weight_set(ad_layout, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	elm_layout_theme_set(ad_layout, "layout", "application", "default");


	box = elm_box_add(ad_layout);
	evas_object_size_hint_align_set(box, EVAS_HINT_FILL, EVAS_HINT_FILL);
	evas_object_size_hint_weight_set(box, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);

	elm_object_part_content_set(ad_layout, "elm.swallow.content", box);

	hoversel = elm_hoversel_add(box);
	elm_hoversel_hover_parent_set(hoversel, ad_layout);
	elm_object_text_set(hoversel, "Auto Refresh: Default");

	elm_hoversel_item_add(hoversel, "Auro Refresh: 30 sec", NULL, ELM_ICON_NONE, NULL, NULL);
	elm_hoversel_item_add(hoversel, "Auro Refresh: 60 sec", NULL, ELM_ICON_NONE, NULL, NULL);
	elm_hoversel_item_add(hoversel, "Auro Refresh: OFF", NULL, ELM_ICON_NONE, NULL, NULL);

	evas_object_size_hint_align_set(hoversel, EVAS_HINT_FILL, 0.5);
	evas_object_size_hint_weight_set(hoversel, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(hoversel);
	elm_box_pack_end(box, hoversel);
	evas_object_data_set(hoversel, "index", (const void *)1);
	evas_object_smart_callback_add(hoversel, "selected", hoversel_selected_cb, ad);

	/* Add Hoversel expanding to screen width */
	hoversel = elm_hoversel_add(box);
	elm_hoversel_hover_parent_set(hoversel, ad_layout);
	elm_object_text_set(hoversel, "Gender");

	elm_hoversel_item_add(hoversel, "Male", NULL, ELM_ICON_NONE, NULL, NULL);
	elm_hoversel_item_add(hoversel, "Female", NULL, ELM_ICON_NONE, NULL, NULL);

	evas_object_size_hint_align_set(hoversel, EVAS_HINT_FILL, 0.5);
	evas_object_size_hint_weight_set(hoversel, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(hoversel);
	elm_box_pack_end(box, hoversel);
	evas_object_data_set(hoversel, "index", (const void *)2);
	evas_object_smart_callback_add(hoversel, "selected", hoversel_selected_cb, ad);

	hoversel = elm_hoversel_add(box);
	elm_hoversel_hover_parent_set(hoversel, ad_layout);
	elm_object_text_set(hoversel, "Age Group");

	elm_hoversel_item_add(hoversel, "18", NULL, ELM_ICON_NONE, NULL, NULL);
	elm_hoversel_item_add(hoversel, "24", NULL, ELM_ICON_NONE, NULL, NULL);
	elm_hoversel_item_add(hoversel, "34", NULL, ELM_ICON_NONE, NULL, NULL);
	elm_hoversel_item_add(hoversel, "44", NULL, ELM_ICON_NONE, NULL, NULL);

	evas_object_size_hint_align_set(hoversel, EVAS_HINT_FILL, 0.5);
	evas_object_size_hint_weight_set(hoversel, EVAS_HINT_EXPAND, EVAS_HINT_EXPAND);
	evas_object_show(hoversel);
	elm_box_pack_end(box, hoversel);

	evas_object_data_set(hoversel, "index", (const void *)3);
	evas_object_smart_callback_add(hoversel, "selected", hoversel_selected_cb, ad);



	adview_add_banner_ad(&ad->banner_handle_3, ad_layout, BANNER_AD_SIZE_SMALL);
	adview_banner_load(ad->banner_handle_3);
	banner_ad_event_callback_s callback = {0,};
	callback.banner_ad_load_request_failed = request_failed_banner;
	callback.banner_ad_load_request_succeeded = request_success_banner;
	adview_banner_ad_register_callbacks(ad->banner_handle_3, &callback, ad);

	nf_it = elm_naviframe_item_push(ad->nf, "Banner Ads", NULL, NULL, ad_layout, NULL);
	elm_naviframe_item_pop_cb_set(nf_it, naviframe_pop_cb, ad);
}
