/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */

#include "main.h"

Evas_Object *listener_banner_handle;
Evas_Object *label;

int count = 1;

void
banner_request_success(Evas_Object *banner_handle, void *user_data)
{
	if(listener_banner_handle == banner_handle){
		dlog_print(DLOG_DEBUG, LOG_TAG, "REQUEST SUCCESS CALLBACK");
		char text[128] = {0, };
		snprintf(text, 127, "<align=center><font_size=32>banner_request_success cb: %d</font_size></align>", count++);
		elm_object_text_set(label, text);
		evas_object_show(banner_handle);
	}
}

void
banner_request_failed(Evas_Object *banner_handle, adlib_err err, void *user_data)
{
	if(listener_banner_handle == banner_handle){
		dlog_print(DLOG_DEBUG, LOG_TAG, "REQUEST FAILED CALLBACK");
		char text[128] = {0, };
		snprintf(text, 127, "<align=center><font_size=32>banner_request_failed cb: %d</font_size></align>", count++);
		elm_object_text_set(label, text);
	}
}

static void banner_ad_opened(Evas_Object *banner_handle, void *user_data)
{
	if(listener_banner_handle == banner_handle){
		dlog_print(DLOG_DEBUG, LOG_TAG, "AD OPENED CALLBACK");
		char text[128] = {0, };
		snprintf(text, 127, "<align=center><font_size=32>banner_ad_opened cb: %d</font_size></align>", count++);
		elm_object_text_set(label, text);
	}
}
void
ad_listeners_cb(void *data, Evas_Object *obj, void *event_info)
{
	Evas_Object *nf = data;
	listener_banner_handle = NULL;

	Evas_Object *ad_layout = elm_layout_add(nf);
	elm_layout_theme_set(ad_layout, "layout", "application", "default");

	label = elm_label_add(ad_layout);
	elm_object_text_set(label, "<align=center><font_size=32>Ad listener cb start</font_size></align>");
	elm_object_part_content_set(ad_layout,"elm.swallow.content", label);
	evas_object_show(label);

	banner_ad_event_callback_s callback = {0,};
	callback.banner_ad_load_request_failed = banner_request_failed;
	callback.banner_ad_load_request_succeeded = banner_request_success;
	callback.banner_ad_opened = banner_ad_opened;



	adview_add_banner_ad(&listener_banner_handle, ad_layout, BANNER_AD_SIZE_SMALL);
	/* If you don't use adview_banner_set_position then the ad will be shown at the bottom. */
	adview_banner_load(listener_banner_handle);

	adview_banner_ad_register_callbacks(listener_banner_handle, &callback, NULL);

	elm_naviframe_item_push(nf, "Ad Listeners", NULL, NULL, ad_layout, NULL);
}
