/*
 * Copyright (c) 2015 Samsung Electronics Co., Ltd All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the License);
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an AS IS BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include <app.h>
#include <Elementary.h>
#include <system_settings.h>
#include <dlog.h>
#include <efl_extension.h>

#include <adlib.h>

#define TIZEN_ENGINEER_MODE
#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
#define LOG_TAG "adlibviewexample"

#if !defined(PACKAGE)
#define PACKAGE "org.example.adlibviewexample"
#endif

#define ELM_DEMO_EDJ "/opt/usr/apps/org.tizen.adlibviewexample/res/edje/adlibviewexample.edj"
#define ICON_DIR "/opt/usr/apps/org.tizen.adlibviewexample/res/images"


typedef struct appdata {
	Evas_Object *win;
	Evas_Object *conform;
	Evas_Object *layout;
	Evas_Object *fb;
	Evas_Object *nf;

	Evas_Object *banner_handle_1;
	Evas_Object *banner_handle_2;
	Evas_Object *banner_handle_3;
	Eina_Bool is_ready;
} appdata_s;


void interstitial_ad_page_cb(void *data, Evas_Object *obj, void *event_info);
void banner_ad_page_cb(void *data, Evas_Object *obj, void *event_info);
void banner_ad_swallow_page_cb(void *data, Evas_Object *obj, void *event_info);
void ad_listeners_cb(void *data, Evas_Object *obj, void *event_info);
void banner_ad_advanced_cb(void *data, Evas_Object *obj, void *event_info);
void banner_ad_advanced_settings_cb(void *data, Evas_Object *obj, void *event_info);

void request_success_interstitial( void *user_data);
