/*
* Copyright (c) 2000-2015 Samsung Electronics Co., Ltd All Rights Reserved
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
*/

/*
 * adlib_interstitial_adview.h
 *
 *  Created on: Oct 22, 2015
 *      Author: anand.r
 */

#ifndef ADLIB_INTERSTITIAL_ADVIEW_H_
#define ADLIB_INTERSTITIAL_ADVIEW_H_

#include "adlib.h"

#ifdef __cplusplus
extern "C" {  // only need to export C interface if
// used by C++ source code
#endif


/**
 * This api will add the interstitial ad on the parent received.
 * @param[in]
 * Evas_Object *eo : parent object
 *
 * @retval #ADLIB_AD_NO_ERROR Success.
 * @retval #ADLIB_AD_INTERNAL_ERROR Internal error.
 * @retval #ADLIB_AD_INVALID_PARAMETERS Invalid parameter.
 * @retval #ADLIB_AD_ADLIB_NOT_INITIALIZED If adlib is not initialised. i.e adlib_init() not called.
 *
 * @return
 * adlib_err : Returns ADLIB_AD_NO_ERROR on success or with the error occurred.
 *
 * @note
 * This will only create the object and will not show ad.
 */
EXPORT_API adlib_err
adview_add_interstitial_ad(Evas_Object *eo);

/**
 * Loads the interstitial ad.
 * Returns the success or failure result to the listener callbacks.
 * Please see OnLoadFailed and OnLoadSucceeded callbacks.
 *
 * @retval #ADLIB_AD_NO_ERROR Success.
 * @retval #ADLIB_AD_INTERNAL_ERROR Internal error.
 *
 * @return
 * adlib_err : Returns ADLIB_AD_NO_ERROR on success or with the error occurred.
 */
EXPORT_API adlib_err
adview_interstitial_load(void);

/**
 * Shows the interstitial ad.
 *
 * @retval #ADLIB_AD_NO_ERROR Success.
 * @retval #ADLIB_AD_INTERNAL_ERROR Internal error.
 * @return
 * adlib_err : Returns ADLIB_AD_NO_ERROR on success or with the error occurred.
 */
EXPORT_API adlib_err
adview_interstitial_show(void);

/**
 * Adds the interstitial ad callback handler.
 * @param[in] callback The set of callback functions to handle ad lifecycle events
 *
 * @retval #ADLIB_AD_NO_ERROR Success.
 * @retval #ADLIB_AD_INTERNAL_ERROR Internal error.
 * @retval #ADLIB_AD_INVALID_PARAMETERS Invalid parameter.
 * @retval #ADLIB_AD_ADLIB_NOT_INITIALIZED If adlib is not initialised. i.e adlib_init() not called.
 * @return
 * adlib_err : Returns ADLIB_AD_NO_ERROR on success or with the error occurred.
 *
 */
EXPORT_API adlib_err
adview_interstitial_ad_register_callbacks(interstitial_ad_event_callback_s *callback, void *user_data);

#ifdef __cplusplus
}
#endif

#endif /* ADLIB_INTERSTITIAL_ADVIEW_H_ */
