﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BatteryApp.Tizen.Wearable;
using Tizen.System;

// Register the dependency service by adding the following: 
[assembly: Xamarin.Forms.Dependency(typeof(BatteryImpl))]

namespace BatteryApp.Tizen.Wearable
{
    public class BatteryImpl:Ibattery
    {
        // Get the remaining charge percentage using Tizen.System.Battery class.
        public int RemainingChargePercent            
        {
            get
            {
                return (int)(Battery.Percent);
            }

        }

        //Get the device battery level using Tizen.System.BatteryLevelStatus enumeration.
        public string BatteryLevel
        {
            get
            {
                BatteryLevelStatus status;
                status = Battery.Level;
                return (string)(status.ToString());
            }
        }

        // Get the current battery charging state using the IsCharging property. 
        public string BatteryStatus
        {
            get
            {
                bool charging;
                charging = Battery.IsCharging;
                return (string)(charging.ToString());
            }
        }
    }
}
