﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Xamarin.Forms;
using Xamarin.Forms.Xaml;

namespace BatteryApp
{
	[XamlCompilation(XamlCompilationOptions.Compile)]
	public partial class MainPage : ContentPage
	{
		public MainPage ()
		{
			InitializeComponent ();
		}

        public void Onbuttonpercent(object sender, EventArgs e)
        {
            // Using DependencyService.get method with the interface getting the percentage from Tizen.System.Battery class.
            var bat = DependencyService.Get<Ibattery>();   
            this.textPercentage.Text = bat.RemainingChargePercent.ToString();
        }

        public void Onbuttonlevel(object sender, EventArgs e)
        {
            // Using DependencyService.get method with the interface getting the device battery level using Tizen.System.BatteryLevelStatus enumeration.
            var bat = DependencyService.Get<Ibattery>();
            this.textLevel.Text = bat.BatteryLevel;
        }

        public void Onbuttonstatus(object sender, EventArgs e)
        {
            // Using DependencyService.get method with the interface getting the current battery charging state using the IsCharging property. 
            var bat = DependencyService.Get<Ibattery>();
            bool status = Convert.ToBoolean(bat.BatteryStatus);
            if (status == true)
            {
                this.textStatus.Text = "Is charging";
            }
            else
            {
                this.textStatus.Text = "Not charging";
            }
        }

        public void Onreset(object sender, EventArgs e)
        {
            // Clear the labels.
            this.textPercentage.Text = "";
            this.textLevel.Text = "";
            this.textStatus.Text = "";
        }
    }
}